function [KE,ME]=lkm(E,NU,density,dx,dy,h)
D=E*[1 NU 0;NU 1 0;0 0 (1-NU)/2]/(1-NU*NU);
nodes=[0 0;dx 0;dx dy;0 dy];
point=1/sqrt(3);
gaussp(1,1)=-point;  gaussp(1,2)=-point; 
gaussp(2,1)=point;   gaussp(2,2)=-point; 
gaussp(3,1)=point;   gaussp(3,2)=point;
gaussp(4,1)=-point;  gaussp(4,2)=point;
KE=0; ME=0;
for i=1:4
s=gaussp(i,1); t=gaussp(i,2);
J1=[-(1-t) 1-t 1+t -(1+t);-(1-s) -(1+s) 1+s 1-s]/4;     
J=J1*nodes; DN_XY=inv(J)*J1;
B1=[DN_XY(1,1) 0;0 DN_XY(2,1);DN_XY(2,1) DN_XY(1,1)];
B2=[DN_XY(1,2) 0;0 DN_XY(2,2);DN_XY(2,2) DN_XY(1,2)];
B3=[DN_XY(1,3) 0;0 DN_XY(2,3);DN_XY(2,3) DN_XY(1,3)];
B4=[DN_XY(1,4) 0;0 DN_XY(2,4);DN_XY(2,4) DN_XY(1,4)];
B=[B1 B2 B3 B4]; clear B1 B2 B3 B4 DN_XY
N=[(1-s)*(1-t) (1+s)*(1-t) (1+s)*(1+t) (1-s)*(1+t)]/4; 
NN=[N(1) 0 N(2) 0 N(3) 0 N(4) 0;0 N(1) 0 N(2) 0 N(3) 0 N(4)];  
KE=KE+B'*D*B*det(J)*h; clear B s t
ME=ME+NN'*NN*density*det(J)*h; clear NN J
end